package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.lego.CsvBuilder;
import gov.cms.grouper.snf.lego.Pair;
import gov.cms.grouper.snf.lego.SnfComparator;
import gov.cms.grouper.snf.lego.SnfUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class CmgForPtOtRow extends BasicRow {

  private String clinicalCategory;
  private Integer functionScoreLow;
  private Integer functionScoreHigh;
  private String cmg;

  private CmgForPtOtRow() {
    this(null, null, null, null);
  }

  public CmgForPtOtRow(String clinicalCategory, Integer functionScoreLow, Integer functionScoreHigh,
      String cmg) {
    super();
    this.clinicalCategory = clinicalCategory;
    this.functionScoreLow = functionScoreLow;
    this.functionScoreHigh = functionScoreHigh;
    this.cmg = cmg;
  }

  public String getClinicalCategory() {
    return this.clinicalCategory;
  }

  public Integer getFunctionScoreLow() {
    return this.functionScoreLow;
  }

  public Integer getFunctionScoreHigh() {
    return this.functionScoreHigh;
  }

  public String getCmg() {
    return this.cmg;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = super.getHashCode(result, prime);
    result =
        prime * result + ((this.clinicalCategory == null) ? 0 : this.clinicalCategory.hashCode());
    result = prime * result + ((this.cmg == null) ? 0 : this.cmg.hashCode());
    result =
        prime * result + ((this.functionScoreHigh == null) ? 0 : this.functionScoreHigh.hashCode());
    result =
        prime * result + ((this.functionScoreLow == null) ? 0 : this.functionScoreLow.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (this.getClass() != obj.getClass()) {
      return false;
    }
    CmgForPtOtRow other = (CmgForPtOtRow) obj;
    if (super.equals(other) == false) {
      return false;
    }

    if (this.clinicalCategory == null) {
      if (other.clinicalCategory != null) {
        return false;
      }
    } else if (!this.clinicalCategory.equals(other.clinicalCategory)) {
      return false;
    }
    if (this.cmg == null) {
      if (other.cmg != null) {
        return false;
      }
    } else if (!this.cmg.equals(other.cmg)) {
      return false;
    }
    if (this.functionScoreHigh == null) {
      if (other.functionScoreHigh != null) {
        return false;
      }
    } else if (!this.functionScoreHigh.equals(other.functionScoreHigh)) {
      return false;
    }
    if (this.functionScoreLow == null) {
      if (other.functionScoreLow != null) {
        return false;
      }
    } else if (!this.functionScoreLow.equals(other.functionScoreLow)) {
      return false;
    }
    return true;
  }

  public static class Builder extends CsvBuilder<CmgForPtOtRow> {
    private static final BiConsumer<CmgForPtOtRow, String> functionScoreLow =
        (val, str) -> val.functionScoreLow = SnfUtils.parse(str, null);

    private static final BiConsumer<CmgForPtOtRow, String> functionScoreHigh =
        (val, str) -> val.functionScoreHigh = SnfUtils.parse(str, null);

    private static final BiConsumer<CmgForPtOtRow, String> clinicalCategory =
        (val, str) -> val.clinicalCategory = SnfUtils.clean(str);

    private static final BiConsumer<CmgForPtOtRow, String> cmg =
        (val, str) -> val.cmg = SnfUtils.clean(str);

    private static final Builder singleton = new Builder();

    private Builder() {
      super(CmgForPtOtRow::new, Builder.initCsvMapping());
    }

    public static Map<Integer, BiConsumer<CmgForPtOtRow, String>> initCsvMapping() {
      Map<Integer, BiConsumer<CmgForPtOtRow, String>> result = new HashMap<>();
      result.put(0, Builder.clinicalCategory);
      result.put(1, BasicRow.getLowVersionParser());
      result.put(2, BasicRow.getHighVersionParser());
      result.put(3, Builder.functionScoreLow);
      result.put(4, Builder.functionScoreHigh);
      result.put(5, Builder.cmg);

      return Collections.unmodifiableMap(result);
    }

    public static Builder of() {
      return Builder.singleton;
    }
  }

}
